ScriptName FollowerAliasScript extends ReferenceAlias

DialogueFollowerScript Property DialogueFollower Auto

ReferenceAlias Property speakerREF Auto
Faction Property nwsFF_HelmFac Auto ; helmet faction
Form Property wornHelmet Auto Hidden

Event OnActivate(ObjectReference akActionRef)
	if akActionRef == Game.GetPlayer()
		speakerREF.ForceRefTo(self.GetActorRef())
	endif
EndEvent

Event OnUpdateGameTime()

	;kill the update if the follower isn't waiting anymore
	If Self.GetActorRef().GetAv("WaitingforPlayer") == 0
		UnRegisterForUpdateGameTime()
	Else
; 		debug.trace(self + "Dismissing the follower because he is waiting and 3 days have passed.")
		DialogueFollower.DismissFollower(5)
		UnRegisterForUpdateGameTime()
	EndIf	
	
EndEvent

Event OnUpdate()
	; smooth transition
	actor myActor = self.GetActorRef()
	if (!myActor.IsInCombat()) && (myActor.GetItemCount(wornHelmet) > 0)
		myActor.UnequipItem(wornHelmet, False, True)
	endif
EndEvent

Event OnUnload()

	;if follower unloads while waiting for the player, wait three days then dismiss him.
	If Self.GetActorRef().GetAv("WaitingforPlayer") == 1
		(GetOwningQuest() as DialogueFollowerScript).FollowerWait()
	EndIf

EndEvent

; Event OnLocationChange(Location akOldLoc, Location akNewLoc)
	; RegisterForSingleUpdate(2.0)
; EndEvent

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
	actor myActor = self.GetActorRef()

	if myActor.IsInFaction(nwsFF_HelmFac)
		Armor myArmor = akBaseObject as Armor
		if myArmor && (!myActor.IsInCombat())
			int myMask = myArmor.GetSlotMask()
			if myArmor.IsHelmet() || myArmor.IsClothingHead() || (myMask >= 4096 && myMask <= 4099) || (myMask >= 6144 && myMask <= 6147) || myMask == 12291
				if akBaseObject != wornHelmet

					wornHelmet = akBaseObject
					string actName = myActor.GetBaseObject().GetName()
					debug.notification("Headwear Stored for "+actName)
					myActor.UnequipItem(wornHelmet, False, True)
				else
					if wornHelmet && (myActor.IsEquipped(wornHelmet))
						myActor.UnequipItem(wornHelmet, False, True)
					endif
				endif
			else
				if wornHelmet && (myActor.GetItemCount(wornHelmet) == 0)
					wornHelmet = None
				endif
			endif
			
		endif
	endif

EndEvent

Event OnCombatStateChanged(Actor akTarget, int aeCombatState)

	actor myActor = self.GetActorRef()
	bool helmFac = myActor.IsInFaction(nwsFF_HelmFac)

	If (akTarget == Game.GetPlayer())
; 		debug.trace(self + "Dismissing follower because he is now attacking the player")
		(GetOwningQuest() as DialogueFollowerScript).DismissFollower(0, 0)
	EndIf

	if aeCombatState == 0
		if wornHelmet && helmFac
			RegisterForSingleUpdate(6.0)
		endif

	elseif aeCombatState == 1
		if wornHelmet && helmFac
			if (!myActor.IsEquipped(wornHelmet)) && (myActor.GetItemCount(wornHelmet) > 0)
				myActor.EquipItem(wornHelmet, False, True)
			endif
		endif

	endif

	; actor selfActor = self.GetActorRef()

	; if (aeCombatState == 1) ; combat start
		; RegisterForSingleUpdate(cbtTimer)
	; elseif (aeCombatState == 0) ; combat end
		; UnregisterForUpdate()
		; if (!Game.GetPlayer().IsInCombat())
			; if selfActor.IsInCombat()
				; selfActor.StopCombat()
			; endif
		; endif
	; endif

EndEvent

Event OnDeath(Actor akKiller)

; 	debug.trace(self + "Clearing the follower because the player killed him.")
	PlayerFollowerCount.SetValue(0)
	Self.GetActorRef().RemoveFromFaction(CurrentHirelingFaction)
	Self.Clear()
	
EndEvent
GlobalVariable Property PlayerFollowerCount  Auto  
Faction Property CurrentHirelingFaction Auto